using System;

namespace SPStudio
{
	/// <summary>
	/// Provides methods that handle vector arithmatic.
	/// </summary>
	public class VectorMath
	{
		#region Constructor Takes No Params
		/// <summary>
		/// Default constructor.
		/// </summary>
		public VectorMath()
		{
		}
		#endregion

		#region DOT and CROSS Products
		/// <summary>
		/// Performs the CROSS
		/// product of the two 
		/// vectors entered.
		/// </summary>
		/// <param name="V1"></param>
		/// <param name="V2"></param>
		/// <returns></returns>
		public Vector3D CROSS(Vector3D V1, Vector3D V2)
		{
			Vector3D returnVector = new Vector3D();
			returnVector.x = (V1.y*V2.z) - (V1.z*V2.y);
			returnVector.y = (V1.z*V2.x) - (V1.x*V2.z);
			returnVector.z = (V1.x*V2.y) - (V1.y*V2.x);
			return returnVector;
		}

		/// <summary>
		/// Performs the DOT
		/// product of the
		/// vectors entered.
		/// </summary>
		/// <param name="V1"></param>
		/// <param name="V2"></param>
		/// <returns></returns>
		public double DOT(Vector3D V1, Vector3D V2)
		{
			return (V1.x*V2.x) + (V1.y*V2.y) + (V1.z*V2.z);
		}
		#endregion

		#region Addition Of Vectors, Subtraction of Vectors, And Multiplication By Scalar
		/// <summary>
		/// Add two vectors.
		/// </summary>
		/// <param name="V1"></param>
		/// <param name="V2"></param>
		/// <returns></returns>
		public Vector3D ADD(Vector3D V1, Vector3D V2)
		{
			Vector3D returnVector = new Vector3D();
			returnVector.x = V1.x+V2.x;
			returnVector.y = V1.y+V2.y;
			returnVector.z = V1.z+V2.z;
			return returnVector;
		}

		/// <summary>
		/// Subtract two vectors.
		/// </summary>
		/// <param name="V1"></param>
		/// <param name="V2"></param>
		/// <returns></returns>
		public Vector3D SUB(Vector3D V1, Vector3D V2)
		{
			Vector3D returnVector = new Vector3D();
			returnVector.x = V1.x-V2.x;
			returnVector.y = V1.y-V2.y;
			returnVector.z = V1.z-V2.z;
			return returnVector;
		}

		/// <summary>
		/// Multiply a vector by a constant.
		/// </summary>
		/// <param name="V"></param>
		/// <param name="C"></param>
		/// <returns></returns>
		public Vector3D MULT(Vector3D V, double C)
		{
			Vector3D returnVector = new Vector3D();
			returnVector.x = V.x * C;
			returnVector.y = V.y * C;
			returnVector.z = V.z * C;
			return returnVector;
		}
		#endregion
	}
}
